/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.syncpositional;

import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.syncpositional.IPositionalData;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketSendPositionalDataToClients {
    private final GlobalPos pos;
    private final IPositionalData data;

    public PacketSendPositionalDataToClients(GlobalPos pos, IPositionalData data) {
        this.pos = pos;
        this.data = data;
    }

    public PacketSendPositionalDataToClients(FriendlyByteBuf buf) {
        ResourceKey<Level> dimension = LevelTools.getId(buf.m_130281_());
        this.pos = GlobalPos.m_122643_(dimension, (BlockPos)buf.m_130135_());
        ResourceLocation id = buf.m_130281_();
        this.data = McJtyLib.SYNCER.create(id, buf);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.pos.m_122640_().m_135782_());
        buf.m_130064_(this.pos.m_122646_());
        buf.m_130085_(this.data.getId());
        this.data.toBytes(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> McJtyLib.SYNCER.handle(this.pos, this.data));
        ctx.setPacketHandled(true);
    }
}

